<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin User Management</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.0/font/bootstrap-icons.css" rel="stylesheet">
    <script src="/furba/www/assets/vendor/jquery/jquery.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
    <style>
        body {
            padding: 20px;
        }
    </style>
</head>
<body>
<!-- Start Generation Here -->
<div class="container mt-4">
    <!-- Admin Dashboard Header -->
    <h1 class="mb-4">Admin Dashboard</h1>

    <!-- Navigation Tabs for Admin Interfaces -->
    <!-- These tabs allow you to switch between the Users management UI and the Profiles management UI -->
    <ul class="nav nav-tabs" id="adminTabs" role="tablist">
        <li class="nav-item" role="presentation">
            <!-- Users Tab: shown by default -->
            <button class="nav-link active" id="users-tab" data-bs-toggle="tab" data-bs-target="#users-panel"
                type="button" role="tab" aria-controls="users-panel" aria-selected="true">
                Users
            </button>
        </li>
        <li class="nav-item" role="presentation">
            <!-- Profiles Tab -->
            <button class="nav-link" id="profiles-tab" data-bs-toggle="tab" data-bs-target="#profiles-panel"
                type="button" role="tab" aria-controls="profiles-panel" aria-selected="false">
                Profiles
            </button>
        </li>
    </ul>

    <!-- Tab Content Area -->
    <div class="tab-content mt-3" id="adminTabsContent">
        <!-- Users Interface Panel -->
        <div class="tab-pane fade show active" id="users-panel" role="tabpanel" aria-labelledby="users-tab">
            <!-- Embed the Users management UI in an iframe.
                 This interface includes creating, updating, and deleting users as provided in users/index.php -->
            <iframe src="users/index.php" style="width: 100%; height: 700px; border: none;" title="Users Interface"></iframe>
        </div>

        <!-- Profiles Interface Panel -->
        <div class="tab-pane fade" id="profiles-panel" role="tabpanel" aria-labelledby="profiles-tab">
            <!-- Embed the Profiles management UI in an iframe.
                 This interface is expected to handle creating, loading, and updating profiles, similar to the Users UI. -->
            <iframe src="profiles/index.php" style="width: 100%; height: 700px; border: none;" title="Profiles Interface"></iframe>
        </div>
    </div>
</div>
<!-- End Generation Here -->
```

<!--
Explanation:
1. A container with a header "Admin Dashboard" is created to serve as the main admin UI.
2. A Bootstrap nav-tabs component sets up two tabs: one for Users and one for Profiles.
3. Each tab panel embeds its respective management interface via an iframe.
   - The Users interface is loaded from "users/index.php" and allows for user creation, update, and deletion.
   - The Profiles interface is loaded from "profiles/index.php", which is assumed to provide similar functionality for profiles.
4. Adjust the iframe height as needed to properly display the contained interfaces.

This modular approach keeps the main admin index clean and uses iframes to encapsulate each separate UI.
-->
</body>
</html>
