<?php

// Define the path to the database file
$userId = (int) $_GET['id']; 'USERID'; // Replace 'USERID' with the actual user ID

$userId = str_pad((string) $userId, 8, '0', STR_PAD_LEFT);

$directoryName = "user{$userId}";
$basePath = "../../../data/users/";
$dbPath = $basePath. $directoryName ."/generations.db";


if (createDirectory($directoryName, $basePath)) {
    echo "Directory created successfully.\n";
} else {
    echo "Directory already exists or failed to create.\n";
}

// Check if the directory exists and is writable
if (!is_dir(dirname($dbPath)) || !is_writable(dirname($dbPath))) {
    die("The directory for the database file does not exist or is not writable.");
}

// Create a new SQLite3 database or open an existing one
$db = new SQLite3($dbPath);

// SQL statements to create tables
$createSolesTable = <<<SQL
CREATE TABLE IF NOT EXISTS soles (
    id INTEGER PRIMARY KEY AUTOINCREMENT,
    file TEXT NOT NULL,
    dt DATETIME DEFAULT CURRENT_TIMESTAMP
);
SQL;

$createUppersTable = <<<SQL
CREATE TABLE IF NOT EXISTS uppers (
    id INTEGER PRIMARY KEY AUTOINCREMENT,
    file TEXT NOT NULL,
    dt DATETIME DEFAULT CURRENT_TIMESTAMP
);
SQL;

$createVariantsTable = <<<SQL
CREATE TABLE IF NOT EXISTS variants (
    id INTEGER PRIMARY KEY AUTOINCREMENT,
    file TEXT NOT NULL,
    dt DATETIME DEFAULT CURRENT_TIMESTAMP
);
SQL;

// Execute the SQL statements to create the tables
$db->exec($createSolesTable);
$db->exec($createUppersTable);
$db->exec($createVariantsTable);

echo "Database and tables created successfully.\n";

// Close the database connection
$db->close();


/**
 * Creates a directory using a parameter as part of the path.
 *
 * @param string $directoryName The name of the directory to create.
 * @param string $basePath The base path where the directory will be created.
 * @param int $permissions The permissions for the new directory (default is 0777).
 *
 * @return bool True if the directory was created successfully, false otherwise.
 */
function createDirectory(string $directoryName, string $basePath, int $permissions = 0777): bool
{
    // Construct the full path of the directory
    $fullPath = $basePath . DIRECTORY_SEPARATOR . $directoryName;

    // Check if the directory already exists
    if (is_dir($fullPath)) {
        // If the directory exists, return false
        return false;
    }

    // Try to create the directory
    try {
        // Create the directory with the specified permissions
        mkdir($fullPath, $permissions, true);
        // If the directory was created successfully, return true
        return true;
    } catch (Exception $e) {
        // If an error occurred, print the error message and return false
        echo "Error creating directory: " . $e->getMessage() . "\n";
        return false;
    }
}