<?php
// Define the database file path
$dbFile = '../../../data/users.db';

// Check if the database file already exists
/*if (file_exists($dbFile)) {
    echo "Database file already exists. No need to create it again.";
    exit;
}*/

try {
    // Create (or open) the SQLite database
    $pdo = new PDO("sqlite:$dbFile");
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    // SQL to create the roles table
    $createRolesTableSQL = "
        CREATE TABLE roles (
            id INTEGER PRIMARY KEY AUTOINCREMENT,
            role_id INTEGER NOT NULL UNIQUE,
            role_name TEXT NOT NULL UNIQUE,
            description TEXT NOT NULL,
            active TINYINT DEFAULT 1
        );
    ";

    // Execute the SQL to create the roles table
    $pdo->exec($createRolesTableSQL);

    // SQL to insert default roles
    $insertRolesSQL = "
        INSERT INTO roles (role_id, role_name, description, active) VALUES
        (1, 'admin', 'System administrator with full access', 1),
        (2, 'user', 'Standard user with generation and tags permissions', 1),
        (3, 'demo', 'Visitor with demo access', 1)
    ";

    // Execute the SQL to insert default roles
    $pdo->exec($insertRolesSQL);

    echo "Database, roles table, and default roles created successfully.";
} catch (PDOException $e) {
    echo "Error creating database or tables: " . $e->getMessage();
}
?>