<?php
require_once '../../../config.php';
?><!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin User Management</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.0/font/bootstrap-icons.css" rel="stylesheet">
    <script src="/furba/www/assets/vendor/jquery/jquery.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
    <style>
        body {
            padding: 20px;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="row">
            <div class="col-md-12">
                <ul class="nav nav-tabs">
                    <li class="nav-item">
                        <a class="nav-link active" data-bs-toggle="tab" href="#users" role="tab" aria-controls="users" aria-selected="true">Users</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" data-bs-toggle="tab" href="#create-user" role="tab" aria-controls="create-user" aria-selected="false"><i class="bi bi-plus" title="Create User"></i>Create User</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" data-bs-toggle="tab" href="#update-user" role="tab" aria-controls="update-user" aria-selected="false" onClick=resetUpdateForm()>Update User</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" data-bs-toggle="tab" href="#delete-user" role="tab" aria-controls="delete-user" aria-selected="false">Delete User</a>
                    </li>
                </ul>
                <div class="tab-content">
                    <div class="tab-pane py-5 active" id="users">
                        <h3 class="mb-5">Users</h3>
                        <div class="row g-4" id="users-container">
                        <!-- Users will be dynamically added here -->
                        </div>
                    </div>
                    <div class="tab-pane py-5" id="create-user">
                        <h3 class="mb-5">Create User</h3>
                        <form id="create-user-form">
                            <div class="mb-3">
                                <label for="username" class="form-label">Username</label>
                                <input type="text" class="form-control" id="username" name="username" required>
                            </div>
                            <div class="mb-3">
                                <label for="password" class="form-label">Password</label>
                                <input type="password" class="form-control" id="password" name="password" required>
                            </div>
                            <div class="mb-3">
                                <label for="email" class="form-label">Email</label>
                                <input type="email" class="form-control" id="email" name="email" required>
                            </div>
                            <button type="submit" class="btn btn-primary">Create User</button>
                        </form>
                    </div>
                    <div class="tab-pane py-5" id="update-user">
                        <h3 class="mb-5">Update User</h3>
                        <form id="update-user-form">
                            <div class="mb-3">
                                <label for="user-id-update" class="form-label">User ID</label>
                                <input type="text" class="form-control" id="user-id-update" name="user_id" required>
                            </div>
                            <div class="mb-3">
                                <label for="username-update" class="form-label">Username</label>
                                <input type="text" class="form-control" id="username-update" name="username" required>
                            </div>
                            <div class="mb-3">
                                <label for="email-update" class="form-label">Email</label>
                                <input type="email" class="form-control" id="email-update" name="email" required>
                            </div>
                            <div class="mb-3">
                                <label for="password-update" class="form-label">New Password (optional)</label>
                                <input type="password" class="form-control" id="password-update" name="password">
                            </div>
                            <button type="submit" class="btn btn-primary">Update User</button>
                        </form>
                    </div>
                    <div class="tab-pane py-5" id="delete-user">
                        <h3 class="mb-5">Delete User</h3>
                        <form id="delete-user-form">
                            <div class="mb-3">
                                <label for="user-id-delete" class="form-label">User ID</label>
                                <input type="text" class="form-control" id="user-id-delete" name="user_id" required>
                            </div>
                            <button type="submit" class="btn btn-primary">Delete User</button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <script>
        function deleteUser(userId) {

            $.ajax({
                type: "POST",
                url: "delete_user.php",
                data: {
                    user_id: userId,
                    csrfToken: '<?=$_SESSION['csrfToken']?>'
                },
                dataType: 'json',
                success: function(response) {
                    if (response.success) {
                        alert(response.message);
                        location.reload();
                    } else {
                        alert("Error: " + response.message);
                    }
                },
                error: function(xhr, status, error) {
                    console.error("AJAX Error:", status, error);
                    console.log("Response Text:", xhr.responseText);
                    alert("Error deleting user. Check console for details.");
                }
            });
        }

        function resetUpdateForm() {
                $("#user-id-update").val('');
                $("#user-id-update").prop("disabled", false);
                $("#username-update").val('');
                $("#email-update").val('');
        }

        $(document).ready(function() {
            // Load users table
            $.ajax({
                type: "GET",
                url: "load_users.php",
                dataType: "json",
                success: function(data) {
                    $("#users-container").empty(); // Clear container before loading
                    $.each(data, function(index, user) {
                        $("#users-container").append(`
                            <div class="col-12 col-md-6 col-lg-4" data-user-id="${user.id}">
                                <div class="card h-100 shadow-sm">
                                    <div class="card-body">
                                        <h5 class="card-title">User #${user.id}</h5>
                                        <div class="mb-2">
                                            <strong>Username:</strong> ${user.username}
                                        </div>
                                        <div class="mb-2">
                                            <strong>Email:</strong> ${user.email}
                                        </div>
                                    </div>
                                    <div class="card-footer bg-transparent d-flex justify-content-between">
                                        <button class="btn btn-sm btn-outline-primary edit-user"
                                            data-id="${user.id}"
                                            data-username="${user.username}"
                                            data-email="${user.email}">
                                            <i class="bi bi-pencil me-1"></i>Edit
                                        </button>
                                        <button class="btn btn-sm btn-outline-danger delete-user"
                                            data-id="${user.id}">
                                            <i class="bi bi-trash me-1"></i>Delete
                                        </button>
                                    </div>
                                </div>
                            </div>
                        `);
                    });
                }
            });

            $(document).on('click', '.edit-user', function() {
                var userId = $(this).data('id');
                var username = $(this).data('username');
                var email = $(this).data('email');

                // Fill update form with user data
                $("#user-id-update").val(userId);
                $("#user-id-update").prop("disabled", true);
                $("#username-update").val(username);
                $("#email-update").val(email);

                // Switch to update tab
                $('a[href="#update-user"]').tab('show');
            });

            // Create user form submission
            $("#create-user-form").submit(function(event) {
                event.preventDefault();
                var username = $("#username").val();
                var password = $("#password").val();
                var email = $("#email").val();

                $.ajax({
                    type: "POST",
                    url: "create_user.php",
                    data: {
                        username: username,
                        password: password,
                        email: email,
                        csrfToken: '<?=$_SESSION['csrfToken']?>'
                    },
                    dataType: 'json',
                    success: function(response) {
                        if (response.success) {
                            alert(response.message);
                            location.reload();
                        } else {
                            alert("Error: " + response.message);
                        }
                    },
                    error: function(xhr, status, error) {
                        console.error("AJAX Error:", status, error);
                        console.log("Response Text:", xhr.responseText);
                        alert("Error creating user. Check console for details.");
                    }
                });
            });

            $("#update-user-form").submit(function(event) {
                event.preventDefault(); // Prevent default form submission

                // Retrieve input values for user update
                var userId = $("#user-id-update").val();
                var username = $("#username-update").val();
                var email = $("#email-update").val();
                var password = $("#password-update").val();

                // Send AJAX POST request for updating user data
                $.ajax({
                    type: "POST",
                    url: "update_user.php",
                    data: {
                        user_id: userId,
                        username: username,
                        email: email,
                        password: password,
                        csrfToken: '<?=$_SESSION['csrfToken']?>'
                    },
                    dataType: "json",
                    success: function(response) {
                        // If the update is successful, notify the user and refresh the page
                        if (response.success) {
                            alert(response.message);
                            location.reload();
                        } else {
                            alert("Error: " + response.message);
                        }
                    },
                    error: function(xhr, status, error) {
                        console.error("AJAX Error:", status, error);
                        console.log("Response Text:", xhr.responseText);
                        alert("Error updating user. Check console for details.");
                    }
                });
            });

            // Delete user form submission
            $(document).on('click', '.delete-user', function() {
                var userId = $(this).data('id');

                if (confirm('Are you sure you want to delete this user?')) {
                    deleteUser(userId);
                }
            });
            $("#delete-user-form").submit(function(event) {
                event.preventDefault();
                var userId = $("#user-id-delete").val();
                if (confirm('Are you sure you want to delete this user?')) {
                    deleteUser(userId);
                }
            });
        });
    </script>
</body>
</html>