<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

require_once __DIR__.'/../../config.php';


// Set JSON header for API response
header('Content-Type: application/json');
header('X-Content-Type-Options: nosniff');

// Validate the user's fingerprint
if (!SessionHelper::validateFingerprint()) {
    // Fingerprint validation failed
    http_response_code(403);
    echo json_encode([
        'success' => false,
        'message' => 'Invalid fingerprint'
    ]);
    exit;
}

TokenHelper::verifyBearerToken();

// Retrieve user information from the session
$user_id = SessionHelper::get('FURBA_id', null);

// Check if user is logged in
if (!$user_id) {
    // User not authenticated
    http_response_code(401);
    echo json_encode([
        'success' => false,
        'message' => 'User not authenticated'
    ]);
    exit;
}

$uid = ToolsHelper::idString($user_id);

$directoryName = 'user'.$uid;
$basePath = PROJECT_DIR . '/data/users';

ToolsHelper::createDirectory($directoryName, $basePath);

$db = PROJECT_DIR . '/data/users/'.$directoryName.'/generations.db';

$pdo = new PDO("sqlite:$db");
$pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

// Check if a file is provided via POST and validate its existence
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['file'])) {
    // Sanitize the filename to prevent potential security risks
    $file_name = basename($_POST['file']);
    $job_id = pathinfo($file_name, PATHINFO_FILENAME);
    $sole_id = (int) $_POST['sole_id'];
    $generation_type = $_POST['generation_type']?? 'unknown';
    // Define the full path to the file
    $filepath = PROJECT_DIR . '/data/generations/' . $file_name;

    // Check if the file actually exists on the disk
    if (file_exists($filepath)) {
        // Create table if not exists
        $pdo->exec('CREATE TABLE IF NOT EXISTS generations (
            id INTEGER PRIMARY KEY AUTOINCREMENT,
            user_id INTEGER NOT NULL,
            job_id INTEGER NOT NULL,
            sole_id INTEGER NOT NULL,
            generation_type TEXT NOT NULL,
            file_name TEXT UNIQUE NOT NULL,
            created_at DATETIME DEFAULT CURRENT_TIMESTAMP,
            UNIQUE(file_name)
        )');

        // Prepare and execute an insert statement
        $stmt = $pdo->prepare('INSERT OR REPLACE INTO generations (user_id, job_id, sole_id, generation_type, file_name) VALUES (:user_id, :job_id, :sole_id, :generation_type, :file_name)');
        $stmt->bindValue(':user_id', $user_id, PDO::PARAM_INT);
        $stmt->bindValue(':job_id', $job_id, PDO::PARAM_STR);
        $stmt->bindValue(':sole_id', $sole_id, PDO::PARAM_INT);
        $stmt->bindValue(':generation_type', $generation_type, PDO::PARAM_STR);
        $stmt->bindValue(':file_name', $file_name, PDO::PARAM_STR);

        // Execute the statement and check for success
        if ($stmt->execute()) {
            echo json_encode([
                'success' => true,
                'message' => 'File record saved successfully'
            ]);
        } else {
            echo json_encode([
                'success' => false,
                'message' => 'Failed to save file record'
            ]);
        }
    } else {
        // File does not exist
        echo json_encode([
            'success' => false,
            'message' => 'File not found: '. $filepath
        ]);
    }
} else {
    // No file provided
    echo json_encode([
        'success' => false,
        'message' => 'No file specified'
    ]);
}
