<?php
require_once 'config.php';
error_reporting(E_ALL);
ini_set('display_errors', 1);

define('PROJECT_VERSION', 'v'.time());

$_auth = false;
const SWIPER_CARDS_NUM = 1;

$token = TokenHelper::createToken(3600);

$db = PROJECT_DIR .'/data/users.db';

$userAuthorizer = new UserAuthorizer($db);
$_auth = $userAuthorizer->isAuthorized();



if ($_auth) {
    $token = TokenHelper::refreshToken(SessionHelper::get('token', default: $token));
    SessionHelper::set('token', $token);

    $user    = new UserManager($db);
    $profile = new ProfileManager($db);
    $subscriptions = new SubscriptionsHelper();
    $user_id = SessionHelper::get('FURBA_id', false);

    if ($user_id) {

        $_userInfo                  = $user->getUser($user_id);
        $_userInfo['profile']       = $profile->getProfile($user_id);
        $_userInfo['subscriptions'] = $subscriptions->getSubscriptions($_userInfo['profile']['subsription_id']?? 2);


        $user_name = ($_userInfo['profile']['first_name']?? '') .' '. ($_userInfo['profile']['last_name']?? '');
        $user_email = $_userInfo['email']?? '';

        $_role_id = $_userInfo['profile']['role_id']?? 3; //3 - demo
        $user_role = USER_ROLES[$_role_id]['name']?? 'demo';

        $subscription_name = $_userInfo['subscriptions']['subscription_name']?? 'Demo';
        $subscription_days = $_userInfo['subscriptions']['subscription_days']?? 30;
        $subscription_date = $_userInfo['profile']['subscription_start']?? date('Y-m-d H:i:s', time());

        $subscription_generations = $_userInfo['subscriptions']['subscription_generations']?? 50;
        $subscription_saves = $_userInfo['subscriptions']['subscription_saves']?? 5;

        $_unlimited = $_userInfo['subscriptions']['unlimited']?? 0;
        $_unlimitedGens = 99999;

        $user_generated = 0;
        $user_saved = 0;



        define('GENERATIONS', $_unlimited === 1? $_unlimitedGens: $subscription_generations - $user_generated);
        define('SAVES', $_unlimited === 1? $_unlimitedGens: $subscription_saves - $user_saved);

        if ($_unlimited) {
            SessionHelper::set('GENERATIONS_LEFT', $_unlimitedGens);
            SessionHelper::set('SAVES_LEFT', $_unlimitedGens);
        } else {
            SessionHelper::set('GENERATIONS_LEFT', GENERATIONS);
            SessionHelper::set('SAVES_LEFT', SAVES);
        }

        $user_generations_left = $_unlimited===1? '': '('. GENERATIONS . ' '.I18N::get('left').')';
        $user_saves_left       = $_unlimited===1? '': '('. SAVES . ' left)';

        $subscription_due_date = 'Never';
        if ($_unlimited === 0) {
            $subscription_due_date = (!empty($subscription_date))?
            ( date('Y-m-d', strtotime($subscription_date) + $subscription_days*3600*24) ): '';
        }

    }

} else {
    SessionHelper::remove('token');
}

$token = SessionHelper::get('token');

?><!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>FURBA.DESIGN</title>

    <!-- Google Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Fira+Sans:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900&family=IBM+Plex+Sans+Condensed:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;1,100;1,200;1,300;1,400;1,500;1,600;1,700&display=swap" rel="stylesheet">

    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <link href="<?=PROJECT_PATH?>/assets/vendor/bootstrap-icons/bootstrap-icons.css" rel="stylesheet">
    <link href="<?=PROJECT_PATH?>/assets/css/styles.css?<?=PROJECT_VERSION?>" rel="stylesheet">
<script>
const HOME_PATH = "<?=PROJECT_PATH?>";
const API_ENDPOINT = "<?=API_PATH?>";
<?php if($_auth): ?>
sessionStorage.setItem("FurbaDesign", "<?=$token?>");
let GENERATIONS_LEFT = <?=SessionHelper::get('GENERATIONS_LEFT', 0)?>;
let SAVES_LEFT =  <?=SessionHelper::get('SAVES_LEFT', 0)?>;
let selectedModel = null;
let selectedType = null;
<?php endif; ?>

const hideAllSections = function() {
    $('#hero, #about, #pricing').addClass('d-none');
<?php if ($_auth): ?>
    $('#salesLeaders, #whatToCreate, #designVariants, #finalStep, #userProfile').addClass('d-none');
<?php endif; ?>
}

document.addEventListener('DOMContentLoaded', function() {

    // About section toggle
    $('.about-us-btn').click(function(e) {
        e.preventDefault();
        hideAllSections();
        // Show About section
        $('#about').removeClass('d-none');
        $('#about').show();

        // Scroll to top smoothly
        window.scrollTo({top: 0, behavior: 'smooth'});
    });

    // Profile section toggle
    $('.buy-subscription-btn').click(function(e) {
        e.preventDefault();
        // Hide all other sections
        hideAllSections();

        // Show Profile section
        $('#pricing').removeClass('d-none');
        $('#pricing').show();

        // Scroll to top smoothly
        window.scrollTo({top: 0, behavior: 'smooth'});
    });
});
</script>
</head>
<body>
    <nav class="navbar navbar-expand-lg bg-body-tertiary">
        <div class="container">
            <!-- Brand: link to the main homepage -->
            <a class="navbar-brand home-btn" href=""><img src="assets/images/logo320.png" border="0" alt="FURBA.DESIGN"></a>
            <!-- Right aligned section containing language selector and profile dropdown -->
            <div class="d-flex ms-auto">

                <div class="d-none d-sm-inline"><a href="#about" class="get-started-btn about-us-btn">Get Started</a></div>
                <!-- Dropdown with profile icon -->

                <div class="dropdown">
                    <button class="btn" type="button" id="profileDropdown" data-bs-toggle="dropdown" aria-expanded="false">
                        <span class="navbar-toggler-icon"></span>
                    </button>

                    <ul class="dropdown-menu dropdown-menu-end notranslate" aria-labelledby="profileDropdown">
                        <li class="mb-2">
                            <!-- Language Selector Dropdown -->
                            <div class="dropdown me-3">
                                <div class="language-select">
                                    <a href="#language" class="<?=USER_LANGUAGE == 'EN'?'active':''?>" data-language="EN" alt="<?=USER_LANGUAGES['EN']?>">EN</a>
                                    <!--
                                    <a href="#language" class="<?=USER_LANGUAGE == 'TR'?'active':''?>" data-language="TR" alt="<?=USER_LANGUAGES['TR']?>">TR</a>
                                    <a href="#language" class="<?=USER_LANGUAGE == 'IT'?'active':''?>" data-language="IT" alt="<?=USER_LANGUAGES['IT']?>">IT</a>
                                    -->
                                    <a href="#language" class="<?=USER_LANGUAGE == 'RU'?'active':''?>" data-language="RU" alt="<?=USER_LANGUAGES['RU']?>">RU</a>
                                    <a href="#language" class="<?=USER_LANGUAGE == 'CN'?'active':''?>" data-language="CN" alt="<?=USER_LANGUAGES['CN']?>">CN</a>
                                    <!--
                                    <a href="#language" class="<?=USER_LANGUAGE == 'HI'?'active':''?>" data-language="HI" alt="<?=USER_LANGUAGES['HI']?>">HI</a>
                                    -->
                                </div>
                            </div>
                        </li>

                        <?php if ($_auth): ?>
                        <li><a class="dropdown-item profile-btn" href="#profile"><?=I18n::get('Profile')?></a></li>
                        <li><a class="dropdown-item" href="#gallery"><?=I18n::get('Gallery')?></a></li>
                        <li><a class="dropdown-item buy-subscription-btn" href="#pricing"><?=I18n::get('Pricing')?></a></li>
                        <li><a class="dropdown-item about-us-btn" href="#about"><?=I18n::get('About Us')?></a></li>
                        <li><a class="dropdown-item logout-btn" href="#logout"><?=I18n::get('Logout')?></a></li>
                        <?php else: ?>
                        <li><a class="dropdown-item" href="#auth" data-bs-toggle="modal" data-bs-target="#loginModal"><?=I18n::get('Login')?></a></li>
                        <li><a class="dropdown-item buy-subscription-btn" href="#pricing"><?=I18n::get('Pricing')?></a></li>
                        <li><a class="dropdown-item" href="#contacts"><?=I18n::get('Contacts')?></a></li>
                        <?php endif; ?>

                    </ul>
                </div>
            </div>
        </div>
    </nav>
<?php if(!$_auth): ?>
    <!-- Login Modal -->
    <div class="modal fade" id="loginModal" tabindex="-1" aria-labelledby="loginModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title" id="loginModalLabel"><?=I18n::get('Login')?></h4>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <form id="login-form">
                        <div class="mb-3">
                            <label for="username" class="form-label"><?=I18n::get('Username')?></label>
                            <input type="text" class="form-control" id="username" name="username" required>
                        </div>
                        <div class="mb-3">
                            <label for="password" class="form-label"><?=I18n::get('Password')?></label>
                            <input type="password" class="form-control" id="password" name="password" required>
                        </div>
                        <div class="d-grid gap-2">
                            <button type="submit" class="btn btn-primary"><?=I18n::get('Login')?></button>
                        </div>
                    </form>
                    <div id="login-message" class="mt-3"></div>
                </div>
            </div>
        </div>
    </div>
    <script src="<?=PROJECT_PATH?>/assets/js/login<?=!IS_DEV?'.min':''?>.js?<?=PROJECT_VERSION?>"></script>
<?php endif; ?>


    <section id="hero">
        <div class="container cta">
            <div class="row">
                <div class="col-lg-9 text-center text-lg-start">
                    <div class="video-container">
                        <div class="video-circle">
                            <video id="video" src="assets/video/004_V.mp4"></video>
                            <div class="play-pause-btn" id="playPauseBtn">
                                <i class="bi bi-play-fill"></i>
                            </div>
                        </div>
                        <div class="text-container">
                            <h2><?=I18n::get('HelperHeader')?></h2>
                            <p><?=I18n::get('HelperSub')?></p>
                            <?php if ($_auth): ?>
                                <a class="cta-btn align-middle" href="#step1"><?=I18n::get('Try for free')?></a>
                            <?php else: ?>
                                <a class="cta-btn align-middle" href="#login" onclick="showAuthModal()"><?=I18n::get('Try for free')?></a>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <script>
            const video = document.getElementById('video');
            const playPauseBtn = document.getElementById('playPauseBtn');
            const playPauseIcon = playPauseBtn.querySelector('i');

            playPauseBtn.addEventListener('click', () => {
                if (video.paused) {
                    video.play();
                    playPauseIcon.className = 'bi bi-pause-fill';
                } else {
                    video.pause();
                    playPauseIcon.className = 'bi bi-play-fill';
                }
            });
        </script>
    </section>

<?php if (!$_auth): ?>

<script>
document.addEventListener('DOMContentLoaded', showAuthModal());
</script>

<?php else: ?>

    <section id="content">
        <a name="step1"></a>
        <div class="container mt-5" id="salesLeaders">
            <h2 class="mb-4"><strong><?=I18n::get('Step 1')?>:</strong> <?=I18n::get('Choose template')?></h2>
            <p><?=I18n::get('Step1Sub')?></p>

            <div class="d-flex justify-content-center category-buttons">
                <button class="btn btn-outline-secondary category-btn active" data-category="all"><?=I18n::get('All')?></button>
                <button class="btn btn-outline-secondary category-btn" data-category="men"><?=I18n::get('Men')?></button>
                <button class="btn btn-outline-secondary category-btn" data-category="women"><?=I18n::get('Women')?></button>
                <button class="btn btn-outline-secondary category-btn" data-category="kids"><?=I18n::get('Kids')?></button>
            </div>

            <div class="row" id="productGrid">
                <?php foreach ( SALES_LEADERS as $leader ): ?>
                    <div class="col-xs-12 col-sm-6 col-md-4 mb-4" data-category="<?php echo htmlspecialchars($leader['category']); ?>">
                        <div class="card brand-card">
                            <div class="card-body">
                            <?php
                            $flag = $leader['country_id'] ? COUNTRIES[$leader['country_id']]['name']: false;
                            if ($flag): ?>
                                <img src="<?=PROJECT_PATH?>/assets/images/flags/<?=$flag?>.svg" class="img-fluid d-block" style="width:29px; border: 1px solid #EEEEEE; border-radius: 5px;" />
                            <?php endif; ?>
                                <img src="assets/images/brands/<?php echo htmlspecialchars($leader['img']); ?>" class="card-img-top" alt="<?php echo htmlspecialchars($leader['name']); ?>">
                                <div class="sole-select add-button next-btn" data-model="<?php echo htmlspecialchars($leader['id']); ?>">+</div>
                                <p class="card-title text-center"><?php echo htmlspecialchars($leader['title']); ?></p>
                            <?php if (!empty($leader['description'])): ?>
                                <div class="card-description"><p><?php echo htmlspecialchars($leader['description']?? ''); ?></p></div>
                            <?php endif; ?>
                            </div>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
        </div>

        <div class="container mt-5 d-none step-container" id="whatToCreate">
            <div class="breadcrumb-nav">
                <span><a href="#" class="backToStep1"><?=I18n::get('Choose template')?></a> / <?=I18n::get('Choose part')?></span>
            </div>
            <h2 class="mb-4"><strong><?=I18n::get('Step 2')?>:</strong> <?=I18n::get('Choose part')?></h2>
            <div class="row justify-content-center">

                <div class="col-sm-6 col-md-4">
                    <div class="card part-card">
                        <div class="card-body">
                            <h3 class="text-secondary"><?=I18n::get('Sole')?></h3>
                            <img src="assets/images/icon_sole.jpg" class="img-fluid" alt="">
                            <div class="sole-select add-button next-btn" data-type="soles">+</div>
                            <div class="card-description">
                                <p class="text-muted"><?=I18n::get('SoleSub')?></p>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="col-sm-6 col-md-4">
                    <div class="card part-card">
                        <div class="card-body">
                            <h3 class="text-secondary"><?=I18n::get('Upper')?></h3>
                            <img src="assets/images/icon_upper.jpg" class="img-fluid" alt="Slam Jam">
                            <div class="sole-select add-button next-btn" data-type="uppers">+</div>
                            <div class="card-description">
                                <p class="text-muted"><?=I18n::get('UpperSub')?></p>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="col-sm-6 col-md-4">
                    <div class="card part-card">
                        <div class="card-body">
                            <h3 class="text-secondary"><?=I18n::get('Complete')?></h3>
                            <img src="assets/images/icon_shoe.jpg" class="img-fluid" alt="Slam Jam">
                            <div class="sole-select add-button next-btn" data-type="variants">+</div>
                            <div class="card-description">
                                <p class="text-muted"><?=I18n::get('CompleteSub')?></p>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="col-sm-6 col-md-4">

                </div>
            </div>
        </div>

        <div class="container mt-5 d-none step-container" id="designVariants" style="display: none;">
            <div class="breadcrumb-nav">
                <span><a href="#" class="backToStep1"><?=I18n::get('Choose template')?></a> /<a href="#" class="backToStep2"><?=I18n::get('Choose part')?></a></span>
            </div>

            <div class="row">
                <div class="col-md-8">
<?php if( GENERATIONS > 0 ): ?>
                    <div id="Swipe" class="container">
                        <div class="row justify-content-center">
                            <div class="col-sm-8 col-md-10 col-12">

                                <div class="swipe-container" id="swipe-container">

                                    <!-- Loading card -->
                                    <div id="loading-card" class="loading-card">
                                        <div class="text-center">
                                            <div class="spinner-border text-primary mb-2" role="status">
                                                <span class="visually-hidden">Loading...</span>
                                            </div>
                                        </div>
                                    </div>

                                    <?php for($i=1; $i<=SWIPER_CARDS_NUM; $i++): ?>
                                    <div class="swp-cards swipe-card" data-swipe-card-id="card-<?=$i?>">
                                        <div class="card">
                                            <img src="#" class="card-img-top" alt="New Design">
                                            <div class="card-zoom"><i class="bi bi-zoom-in"></i></div>
                                        </div>
                                    </div>
                                    <?php endfor; ?>

                                    <div class="swp-cards swipe-card end-card">
                                        <div class="card"></div>
                                    </div>

                                </div>
                            </div>
                        </div>
                    </div>
                    <link href="<?=PROJECT_PATH?>/assets/css/swipe.css?<?=PROJECT_VERSION?>" rel="stylesheet">
                    <script src="<?=PROJECT_PATH?>/assets/js/swipe<?=!IS_DEV?'.min':''?>.js?<?=PROJECT_VERSION?>"></script>
<?php else: ?>
                    <div class="alert alert-warning text-center" role="alert">
                        <h4>Generations Limit Reached</h4>
                        <p>You have exhausted your current subscription's design generation limit.</p>
                        <div class="d-grid gap-2 mt-3">
                            <button class="btn btn-primary buy-subscription-btn">
                                <i class="bi bi-cart3"></i> Select Pricing Plan
                            </button>
                            <small class="text-muted">Upgrade to continue generating designs</small>
                        </div>
                    </div>
<?php endif; ?>
                </div>

                <div class="col-md-4 mt-1">
                    <div class="d-grid gap-2">
                        <button class="btn btn-warning" id="regenerate">
                            <i class="bi bi-arrow-repeat"></i> Generate
                            <span class="generations-left"><?=$user_generations_left?></span>
                        </button>
                        <button class="btn btn-success" id="saveDesign">
                            <i class="bi bi-floppy"></i> Save Design
                            <span class="saves-left"><?=$user_saves_left?></span>
                        </button>
                    </div>

                    <div class="d-grid gap-2 mt-3 mb-3">
                        <a href="<?=PROJECT_PATH?>/assets/docs/TEMPCONTR_2025.pdf" target="_blank" class="btn btn-info"><i class="bi bi-download"></i> Download agreement</a>
                        <button class="btn btn-secondary"><i class="bi bi-whatsapp"></i> Request conditions</button>
                        <button class="btn btn-danger buy-subscription-btn"><i class="bi bi-cart3"></i> Buy a subscription</button>
                    </div>

                    <div class="d-grid gap-2 mt-3 mb-3">
                        <p>* There will be randomly changed details and shoe colors to demonstrate the capabilities of the system.</p>
                        <p>System generates designs based on parameters. 50% may be inaccurate. You pay only for saved variants.</p>
                    </div>
                </div>
            </div>
        </div>
<?php if( GENERATIONS > 0 ): ?>
        <!-- Modal for Enlarged Swiper Card Image -->
        <div class="modal fade" id="cardImageModal" tabindex="-1" aria-labelledby="cardImageModalLabel" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered modal-lg">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="cardImageModalLabel">Design Preview</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body text-center">
                        <img src="#" class="img-fluid" id="enlargedCardImage" alt="Enlarged Card Image">
                    </div>
                </div>
            </div>
        </div>

        <script>
        // Script to handle opening the modal with enlarged image
        document.addEventListener('DOMContentLoaded', function() {
            const swipeZoomButtons = document.querySelectorAll('.swipe-card .card-zoom');
            const enlargedCardImage = document.getElementById('enlargedCardImage');
            const cardImageModal = new bootstrap.Modal(document.getElementById('cardImageModal'));

            swipeZoomButtons.forEach(zoomButton => {
                zoomButton.addEventListener('click', function() {
                    // Find the corresponding card image
                    const cardImage = this.closest('.swipe-card').querySelector('.card-img-top');

                    // Set the src of the enlarged image to the card's image
                    enlargedCardImage.src = cardImage.src;

                    // Show the modal
                    cardImageModal.show();
                });
            });
        });
        </script>
<?php endif; ?>
    </section>

    <section id="user">
        <div class="container mt-5 d-none" id="userProfile" style="display: none;">
            <div class="row">
                <div class="col-md-6">
                    <div class="card profile-container">
                        <h3 class="text-center mb-3">Profile</h3>
                        <ul class="list-group list-group-flush">
                            <li class="list-group-item">Name: <?=$user_name?></li>
                            <li class="list-group-item">Email: <?=$user_email?></li>
                            <li class="list-group-item">Role: <?=$user_role?></li>
                            <li class="list-group-item">Registration Date: <?=(date('Y-m-d', strtotime($_userInfo['profile']['dt']) ))?></li>
                        </ul>
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="card profile-container">
                        <h3 class="text-center mb-3">Subscription</h3>
                        <ul class="list-group list-group-flush">
                            <li class="list-group-item">Subscription: <?=$subscription_name?></li>
                            <li class="list-group-item">Generations: <span class="generations-left"><?=$user_generations_left?></span></li>
                            <li class="list-group-item">Saves: <span class="saves-left"><?=$user_saves_left?></span></li>
                            <li class="list-group-item">Expires: <?=$subscription_due_date?></li>
                        </ul>
                    </div>
                </div>

            </div>
        </div>
    </section>

<?php endif; ?>

    <section id="info">

        <div id="pricing" class="pricing container mt-5 d-none" style="display: none;">
            <div class="container">
                <div class="section-title">
                    <h3>Pricing</h3>
                    <p>The cost of a monthly subscription that gives you access to the world of AI</p>
                </div>
                <div class="row">
                    <div class="col-lg-4 col-md-6">
                        <div class="box">
                            <h3>Newcomer</h3>
                            <h4><sup>$</sup>50<span> / month</span></h4>
                            <ul>
                                <li>10 designs per day</li>
                                <li>1 saving per day</li>
                                <li>Personal cabinet</li>
                                <li class="na">Formation of collections</li>
                                <li class="na">Loading templates</li>
                            </ul>
                            <div class="btn-wrap">
                                <a href="#" class="btn-buy">Buy Now</a>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-4 col-md-6 mt-4 mt-md-0">
                        <div class="box recommended">
                            <span class="recommended-badge">Recommended</span>
                            <h3>Business</h3>
                            <h4><sup>$</sup>199<span> / month</span></h4>
                            <ul>
                                <li>30 designs per day</li>
                                <li>3 saving per day</li>
                                <li>Personal cabinet</li>
                                <li>Formation of collections</li>
                                <li class="na">Loading templates</li>
                            </ul>
                            <div class="btn-wrap">
                                <a href="#" class="btn-buy">Buy Now</a>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-4 col-md-6 mt-4 mt-lg-0">
                        <div class="box">
                            <h3>Developer</h3>
                            <h4><sup>$</sup>299<span> / month</span></h4>
                            <ul>
                                <li>30 designs per day</li>
                                <li>3 saving per day</li>
                                <li>Personal cabinet</li>
                                <li>Formation of collections</li>
                                <li>Loading templates max. 3</li>
                            </ul>
                            <div class="btn-wrap">
                                <a href="#" class="btn-buy">Buy Now</a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- ======= About Us Section ======= -->
        <div id="about" class="about mt-5 d-none" style="display: none;">

            <div class="container">
                <div class="section-title">
                    <h2>About Us</h2>
                    <h5>Ankka Shoe Design Generation Service by Furba</h5>
                    <p>Furba is proud to introduce a new direction in the fashion industry — Ankka. This unique service leverages powerful artificial intelligence technology to generate shoe designs inspired by the best global brands.</p>
                    <h5>How does it work?</h5>
                    <p>Simply choose a trend or **template**, and our AI will create several original design options for you. You can adjust the parameters to get the perfect collection that suits your preferences. With Ankka, you can easily generate and create the best shoe collections that reflect the latest fashion trends.</p>
                    <p>Ankka is the future of shoe design, available today. Save time and get unique, stylish solutions based on the global fashion industry!</p>
                    <p></p>
                </div>

                <div class="row content">
                    <div class="col-lg-6">
                        <h5>Maximize Your Results with <a href="https://ankka.eu">Ankka.it</a></h5>
                        <p>To achieve the best possible outcomes, we recommend using the Ankka.it service for precise customization. With Ankka.it, you can fine-tune various parameters, such as target market, product type, and other key marketing options. This allows you to tailor your designs and strategies to meet specific business needs and reach your ideal audience.</p>
                        <p>Take control of your product's success with Ankka.it and create designs that resonate with your customers.</p>
                        <p></p>
                    </div>
                    <div class="col-lg-6 pt-4 pt-lg-0">
                        <h5>Grow Your Brand, Expand Your Collection</h5>
                        <p>With our service, you can design any of 42 shoe types and create a unique design tailored specifically to your brand. Not only can you boost your sales, but you can also develop a distinctive identity that sets you apart in the market!</p>
                    </div>
                </div>
            </div>
            <!-- End About Us Section -->

            <!-- ======= Services Section ======= -->
            <div id="services" class="services mt-5">
                <div class="container">
                    <div class="section-title">
                    <h2>Services</h2>
                    <p>What features are created for you and what is possible with Furba and Ankka?</p>
                    </div>
                    <div class="row">
                    <div class="col-lg-4 col-md-6 d-flex align-items-stretch">
                        <div class="icon-box">
                            <div class="icon"><i class="bi bi-magic"></i></div>
                            <h4>Create Shoe Uppers Based on Real-World Soles</h4>
                            <p>Design your shoe uppers using soles already produced by factories worldwide. Choose the best solutions and get a sneak peek into the future of your product before it hits the market!</p>
                        </div>
                    </div>
                    <div class="col-lg-4 col-md-6 d-flex align-items-stretch mt-4 mt-md-0">
                        <div class="icon-box">
                            <div class="icon"><i class="bi bi-magic"></i></div>
                            <h4>Create Soles That Define Your Style</h4>
                            <p>In just 5 minutes, AI will generate a unique sole design for you. Simply choose your preferred manufacturing type and let the creativity flow!</p>
                        </div>
                    </div>
                    <div class="col-lg-4 col-md-6 d-flex align-items-stretch mt-4 mt-lg-0">
                        <div class="icon-box">
                            <div class="icon"><i class="bi bi-pencil-fill"></i></div>
                            <h4>Bring Your Designs to Life</h4>
                            <p>Turn your sketches and drawings into shoe prototypes in just 5 minutes. Your ideas will be brought to life in a visual format—ready to share with your marketing team!</p>
                        </div>
                    </div>
                    <div class="col-lg-4 col-md-6 d-flex align-items-stretch mt-4">
                        <div class="icon-box">
                            <div class="icon"><i class="bi bi-folder-fill"></i></div>
                            <h4>Create Collections, Develop Product Lines, and Analyze Market Demand</h4>
                            <p>Build collections and product groups, design exclusive product lines, and conduct in-depth market demand research—all in one place. Empower your business to stay ahead of trends and meet your customers' needs effectively.</p>
                        </div>
                    </div>
                    <div class="col-lg-4 col-md-6 d-flex align-items-stretch mt-4">
                        <div class="icon-box">
                            <div class="icon"><i class="bi bi-megaphone-fill"></i></div>
                            <h4>Promote Your Products and Expand Your Reach</h4>
                            <p>Boost your product visibility in your market by showcasing your soles and other components to manufacturers. Increase your brand's presence and connect with a wider audience to drive sales and growth.</p>
                        </div>
                    </div>
                    <div class="col-lg-4 col-md-6 d-flex align-items-stretch mt-4">
                        <div class="icon-box">
                            <div class="icon"><i class="bi bi-globe"></i></div>
                            <h4>Expand to New Markets and Find New Partners</h4>
                            <p>Broaden your reach by entering new markets and discovering potential contractors. Unlock new opportunities and expand your business capabilities.</p>
                        </div>
                    </div>
                </div>
            </div>
            <!-- End Services Section -->
<?php $hide = true; if (!$hide): //HIDE SECTION ?>
           <!-- TODO: Add contacts handler-->

            <!-- ======= Contact Section ======= -->
            <div id="contact" class="contact mt-5 d-none" style="display: none;">
                <div class="container">
                    <div class="section-title">
                        <h2>Contact</h2>
                        <p>You can always contact us at our office to clarify details or to conclude a contract!</p>
                    </div>
                </div>

                <div>
                    <iframe
                        src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d3010.336558170405!2d28.9164256!3d41.017892200000006!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x14cabbb1ade07b4d%3A0x41372ea4b54356d2!2sBiruni%20University!5e0!3m2!1sru!2sse!4v1737132841715!5m2!1sru!2sse"
                        width="100%"
                        height="450"
                        style="border:0;"
                        allowfullscreen=""
                        loading="lazy"
                        referrerpolicy="no-referrer-when-downgrade"></iframe>
                </div>

                <div class="container">
                    <div class="row mt-5">
                        <div class="col-lg-4">
                            <div class="info">
                                <div class="address">
                                <i class="ri-map-pin-line"></i>
                                <h4>Location:</h4>
                                <p>Merkezefendi, 75 Sk No:1-13 M. G, 34015 Zeytinburnu/İstanbul, Турция</p>
                                </div>
                                <div class="email">
                                <i class="ri-mail-line"></i>
                                <h4>Email:</h4>
                                <p>info@ankka.eu</p>
                                </div>
                                <div class="phone">
                                <i class="ri-phone-line"></i>
                                <h4>Call:</h4>
                                <p>+90 531 785 91 30</p>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-8 mt-5 mt-lg-0">
                            <form action="forms/contact.php" method="post" role="form" class="php-email-form">
                                <div class="row">
                                <div class="col-md-6 form-group">
                                    <input type="text" name="name" class="form-control" id="name" placeholder="Your Name" required="">
                                </div>
                                <div class="col-md-6 form-group mt-3 mt-md-0">
                                    <input type="email" class="form-control" name="email" id="email" placeholder="Your Email" required="">
                                </div>
                                </div>
                                <div class="form-group mt-3">
                                <input type="text" class="form-control" name="subject" id="subject" placeholder="Subject" required="">
                                </div>
                                <div class="form-group mt-3">
                                <textarea class="form-control" name="message" rows="5" placeholder="Message" required=""></textarea>
                                </div>
                                <div class="my-3">
                                <div class="loading">Loading</div>
                                <div class="error-message"></div>
                                <div class="sent-message">Your message has been sent. Thank you!</div>
                                </div>
                                <div class="text-center"><button type="submit">Send Message</button></div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
            <!-- End Contact Section -->
<?php endif; //Hidden section ?>
        </div>
    </section>

    <footer id="footer">
         <div class="container">
            <img src="<?=PROJECT_PATH?>/assets/images/logo300.png">

            <div class="social-links mb-3">

               <a href="https://www.facebook.com/ankkaai" class="facebook"><i class="bi bi-facebook"></i></a>
               <a href="https://www.instagram.com/ankkaeu/" class="instagram"><i class="bi bi-instagram"></i></a>
               <a href="https://www.youtube.com/@ankkaai" class="google-plus"><i class="bi bi-youtube"></i></a>

            </div>
            <div class="copyright">
               &copy; Copyright <strong><span>ANKKA.eu</span></strong>.
               All Rights Reserved
            </div>
            <div class="credits">
               Designed by ankka.eu<br />
               Programming by <a href="https://markelangelo.com/">Markelangelo</a>
            </div>
    </footer>

    <a href="#" class="back-to-top d-flex align-items-center justify-content-center">
        <i class="bi bi-arrow-up-short"></i>
    </a>

<?php if($_auth): ?>
<script src="<?=PROJECT_PATH?>/assets/js/app<?=!IS_DEV?'.min':''?>.js?<?=PROJECT_VERSION?>"></script>
<script src="<?=PROJECT_PATH?>/assets/js/refresh<?=!IS_DEV?'.min':''?>.js?<?=PROJECT_VERSION?>"></script>
<?php endif; ?>

<?php
/*
echo '<pre>';
if(isset($_userInfo) && !empty($_userInfo)) {
    var_dump($_userInfo);
}
echo '</pre>';
*/
?>

</body>
</html>